	% Example 12.2 
	clear all
	close all
	%  Synthesis of lowpass Lattice filters
	wcT = 0.25*pi;	wsT = 0.35*pi;	
	r = 0.15; Amax =-10*log10(1-r^2); Amin = 40;
	wac = tan(wcT/2); was = tan(wsT/2);	
	N = CA_ORDER_S(wac, was, Amax, Amin);
	N = 5;		
	[G, Z, R_ZEROS, P, wsnew] = CA_POLES_S(wac, was, Amax, Amin, N);	
	[S1num,S1den,S2num, S2den] = SORT_LATTICE_POLES_LP_S(P);
	G = 1;	
	[Xnum, Xden] = S_2_Z(G,S1num, S1den);		
	[R, K, RL] = RICHARDS_REACTANCE_S(Xnum, Xden);
	R
	R1 = R(1); R2 = R(2); R3 = R(3);
	[Xnum, Xden] = S_2_Z(G, S2num, S2den);	
	[R, K, RL] = RICHARDS_REACTANCE_S(Xnum, Xden);
	R
	R4 = R(1); R5 = R(2);
 	alfa1 = (1-R1)/(1+R1)
	alfa2 = (R1-R2)/(R1+R2)
	alfa3 = (R2-R3)/(R2+R3)
	alfa4 = (1-R4)/(1+R4)
	alfa5 = (R4-R5)/(R4+R5)
	
	v1 = 0; v2 = 0; v3 = 0; v4 = 0; v5 = 0;
	a1 = 1;
	x1 = 1; c2 = 1;c3 = 1;c4 =1; c5 = 1;
	for n = 1:50
		% Upper branch
		Temp = alfa3*(-v3 - v2);
		b31 = (-v3 + Temp);
		v3 = v2  + Temp;	
		Temp = alfa2*(b31 - v1);
		b21 = b31 + Temp;
		v2 = v1 + Temp; 
		Temp = alfa1*(b21 - a1);
		b11 = b21 + Temp;
		v1 = a1 + Temp;
		% Lower branch
		Temp = alfa5*(v5 - v4);
		b51 = v5 + Temp;
		v5 = v4 + Temp;
		Temp = alfa4*(b51 - a1);
		b41 = b51 + Temp;
		v4 = a1 + Temp;
		h(n) = 0.5*(b41 - b11);
		a1 = 0;
	end
	%	figure(3)
	%	PLOT_IMPULSE_RESPONSE_Z(h)
	
	%	figure(4)
	[G, Z, P] = IMPULSE_2_P_Z(h, 5)
	%	PLOT_PZ_Z(Z, P)
	%	zoom on
	
	figure(1)
	subplot('position', [0.11 0.4 0.88 0.5]);
	wT = [0:0.001:pi];
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	Att = PZ_2_ATT_Z(G, Z, P, wT); 
	axis_Amax = 60; axis_Tg_max= 30;
	PLOT_Att_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)		
	grid on
	
	
	
